using System;
using System.Xml;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;
using Server.Spells;
using Server.Spells.First;
using Server.Spells.Second;
using Server.Spells.Third;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Spells.Sixth;
using Server.Spells.Seventh;
using Server.Spells.Eighth;
using Server.Spells.Chivalry;
using System.Collections;
using System.Collections.Generic;


namespace Server.Regions
{
	public class WispRegion : DungeonRegion
	{
		public WispRegion( XmlElement xml, Map map, Region parent ) : base( xml, map, parent )
		{
		}
		
		// 		public static int RandomFireHue { get { return Utility.RandomList( 1092, 1066, 1059, 1068, 1078, 1161, 1198, 1259, 1360, 1932,
		//          2019, 2020, 2021, 2162, 2163, 2449, 2454, 2487, 2640, 2622 ); } }

		public override bool OnBeginSpellCast( Mobile m, ISpell s )
		{
			if ( m.AccessLevel > AccessLevel.Player || !m.Player  || ((Spell)s).Scroll != null || s is DivineFurySpell )
				return base.OnBeginSpellCast( m, s );
			
			if ( s is GateTravelSpell || s is RecallSpell || s is MarkSpell || s is PaladinSpell || s is EtherealMount.EtherealSpell || s is Server.Spells.Necromancy.TransformationSpell ||
			    s is Server.Spells.Spellweaving.GiftOfLifeSpell || s is GreaterHealSpell || 
			    s is Server.Spells.Spellweaving.ArcaneForm ||  s is Server.Spells.Spellweaving.ArcaneSummon || s is Server.Spells.Ninjitsu.NinjaSpell || s is Server.Spells.SamuraiMove || s is Server.Spells.Bushido.SamuraiSpell ||
			    s is TeleportSpell || s is Server.Spells.NinjaMove || s is MagicTrapSpell || s is PolymorphSpell || s is MagicLockSpell )
			{
				m.SendLocalizedMessage( 501802 ); // Thy spell doth not appear to work...
				return false;
			}
			
			return base.OnBeginSpellCast( m, s );
		}

		public override bool AllowHousing( Mobile from, Point3D p )
		{
			return false;
		}

		public override bool CanUseStuckMenu( Mobile m )
		{
			return true;
		}
		
		/*public override bool OnResurrect( Mobile m )
		{
			if ( m.AccessLevel == AccessLevel.Player )
			{
				m.SendMessage("Zde nelze ozivovat");
				return false;
			}

			return true;
		}*/
		
		public override bool OnDoubleClick(Mobile m, object o)
		{
			if ( m.AccessLevel > AccessLevel.Player )
				return base.OnDoubleClick(m, o);
			
			if ( /*o is GreaterHealPotion || */o is SuperPotion || o is EtherealMount || o is TotalManaRefreshPotion || o is BankCrystal || o is EnhancedBandage )
			{
				m.SendMessage( "Tento predmet zde nemuzes pouzit." );
				return false;
			}
			else if ( o is Xanthos.Interfaces.IShrinkItem )
			{
				BaseCreature bc = (BaseCreature) ((Xanthos.Interfaces.IShrinkItem)o).ShrunkenPet;
				
				if ( bc != null && bc.IsBonded )
				{
					m.SendMessage( "Zde nemuzes odshrinknout bondle pety." );
					return false;
				}
			}
			else if ( o is BaseMount )
			{
				m.SendLocalizedMessage( 1042317, "", 0x41 ); // You may not ride at this time
				return false;
			}
			
			BaseMount.Dismount( m );

			return base.OnDoubleClick(m, o);
		}
		
		/*public override bool AllowBeneficial(Mobile from, Mobile target)
		{
			if ( ( from is BaseCreature && !((BaseCreature)from).Controlled ) || from.AccessLevel > AccessLevel.Player )
				return base.AllowBeneficial(from, target);

			from.SendMessage("You cannot perform benificial acts on your target.");
			return false;
		}*/
		
		public override bool OnSkillUse( Mobile from, int Skill )
		{
			if ( from.AccessLevel == AccessLevel.Player )
			{
				if ( Skill == ( (int)SkillName.SpiritSpeak  ) )
				{
					from.SendMessage("Tento skill lze nelze pouzit");
					return false;
				}
			}
			
			return base.OnSkillUse( from, Skill );
		}
		
		public override bool OnDamage( Mobile from, ref int Damage )
		{
			if ( from is BaseCreature )
			{
				BaseCreature bc = (BaseCreature) from;
				
				if ( bc.IsBonded )
				{
					from.Kill();
					return false;
				}
				else if ( bc.Controlled && !bc.Summoned ) //10% dmg pro ovladane nesummony
					Damage = (int) ( Damage * 0.1 );
			}
			
			return base.OnDamage( from, ref Damage );
		}
		
		public override bool OnDeath( Mobile m )
		{
			if ( m is BaseCreature && Utility.RandomDouble() < 0.01 )
			{
				BaseCreature bc = (BaseCreature) m;
				
				if ( !bc.Controlled && bc.FightMode != FightMode.Aggressor && bc.Fame > 20000 )
				{
					//bc.PackItem( new PSToken() );
					if ( Utility.RandomDouble() < 0.2 )
					{
						if ( Utility.RandomDouble() < 0.3 )
							bc.PackItem( new ManaPotion() );
						else
							bc.PackItem( new HealPotion() );
					}
				}
			}
			
			return base.OnDeath( m );
		}
	}
}
